<?php

///////////////////////////////////////////////////////////
//
// User settings extraction 
//
//////////////////////////////////////////////////////////

extract( shortcode_atts( array(

	'images' 			=> '',
	'img_position' 		=> 'center center',
	'slideshow_speed' 	=> '3000',
	'transition_speed' 	=> '1000',
	'overlay' 			=> '',
	'slideshow_mask'	=> 'false',
	'section_height' 	=> '400',
	'full_width_cnt' 	=> 'false',
	'full_height' 		=> 'false',
	'padding_top' 		=> '10',
	'padding_bottom' 	=> '10',
	'el_class' 			=> '',

), $atts ) );


$output = $output_overlay = $output_slideshow_box_items = $mk_grid = $mk_grid_end = $mk_mask = $mk_mask_end = '';
$id = uniqid();

global $post;

$query = array(
    'post_type' => 'attachment',
    'post_mime_type' => 'image',
    'post_status' => 'inherit',
    'order' => 'DESC',
    'orderby' => 'post__in'
);

if ($images) {
    $query['post__in'] = explode(',', $images);
}

$r = new WP_Query($query);

///////////////////////////////////////////////////////////
//
// Prepare conditional output
//
//////////////////////////////////////////////////////////

if (!empty($el_class)) {
    $el_class = $el_class;
}

if ($full_width_cnt == "false") {
	$mk_grid 	 = '<div class="mk-grid">';
    $mk_grid_end = '</div>';
}

if ($slideshow_mask == "true") {
	$mk_mask 	 = '<div class="mk-video-mask">';
    $mk_masl_end = '</div>';
}

if (!empty($overlay)) {
    $output_overlay = '<div style="background-color:' . $overlay . ';" class="mk-slideshow-box-color-mask"></div>';
}

if ( $r->have_posts() ) :
	$output_slideshow_box_items .= '<div class="mk-slideshow-box-items">';
    while ( $r->have_posts() ) :
        $r->the_post();
            $image_src_array = wp_get_attachment_image_src($post->ID, 'full', true);
    		$output_slideshow_box_items .= '<div class="mk-slideshow-box-item" style="background-image:url('.mk_thumbnail_image_gen($image_src_array[0], false, false).');"></div>';
    endwhile;
    wp_reset_query();
	$output_slideshow_box_items .= '</div>';
endif;

///////////////////////////////////////////////////////////
//
// HTML output
//
//////////////////////////////////////////////////////////

$output .= '<div id="mk-slideshow-box-'.$id.'" class="mk-slideshow-box mk-page-section full-width-'.$full_width_cnt.' full-height-'.$full_height.' '.$el_class.'">';
$output .= '	'.$output_overlay;
$output .= '	'.$output_slideshow_box_items;
$output .= '	'.$mk_grid.'<div class="mk-slideshow-box-content ">'.wpb_js_remove_wpautop( $content, true ).'</div>'.$mk_grid_end;
$output .= '	'.$mk_mask.$mk_mask_end;
$output .= '</div> <!-- mk-slideshow-box-'.$id.' -->';


///////////////////////////////////////////////////////////
//
// CSS / JS generated by user choice via admin metabox
//
//////////////////////////////////////////////////////////

// Get global JSON contructor object for styles and create local variable
global $app_dynamic_styles;
$app_styles = '';

$app_styles .= '
#mk-slideshow-box-'.$id.' {
	min-height: '.$section_height.'px;
}
.mk-slideshow-box {
	position: relative;
}
.mk-slideshow-box-item {
	display: none;
}
.mk-slideshow-box-item, .mk-slideshow-box-color-mask {
	position: absolute;
	top: 0;
	left: 0;
	width: 100%;
	height: 100%;
	background-size: cover;
	background-position: '.$img_position.';
}
.mk-slideshow-box-content {
	position: relative;
	z-index: 20;
	padding-top: '.$padding_top.'px;
	padding-bottom: '.$padding_bottom.'px;
	padding-left:20px;
	padding-right:20px;
}
.mk-slideshow-box-color-mask {
	z-index: 10;
}';

$output .= '
<script>
   if (window.addEventListener) {
      window.addEventListener("load", hookLoad, false);
    }
    else if (window.attachEvent) {
      window.attachEvent("onload", hookLoad);
    }

	function hookLoad() {
		// Simple Carousel
		var $slider = jQuery("#mk-slideshow-box-'.$id.' .mk-slideshow-box-items"); 
		var $slide = ".mk-slideshow-box-item"; 
		var $transition_time = '.$transition_speed.';
		var $time_between_slides = '.$slideshow_speed.'; 

		function slides(){
		return $slider.find($slide);
		}

		// set active classes
		slides().first().addClass("active").fadeIn($transition_time, function(){
			setTimeout(autoScroll, $time_between_slides);
		});

		// auto scroll 
		function autoScroll(){
			var $i = $slider.find($slide + ".active").index();
			slides().eq($i).removeClass("active").fadeOut($transition_time);
			if (slides().length == $i + 1) $i = -1; // loop to start
			slides().eq($i + 1).addClass("active").fadeIn($transition_time, function() {
				setTimeout(autoScroll, $time_between_slides);
			});
		}
	};
</script>';

// Lets roll
echo $output;


// Hidden styles node for head injection after page load through ajax
echo '<div id="ajax-'.$id.'" class="mk-dynamic-styles">';
echo '<!-- ' . mk_clean_dynamic_styles($app_styles) . '-->';
echo '</div>';


// Export styles to json for faster page load
$app_dynamic_styles[] = array(
  'id' => 'ajax-'.$id ,
  'inject' => $app_styles
);
